Ext.data.JsonP.sol_common_mixins_ObjectSort({"tagname":"class","name":"sol.common.mixins.ObjectSort","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.ObjectSortUtils.js","href":"lib_sol.common.ObjectSortUtils.html#sol-common-mixins-ObjectSort"}],"author":[{"tagname":"author","name":"MHe (ELO Digital Office GmbH)","email":null}],"requires":["sol.common.ObjectSortUtils","sol.common.ObjectUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"mixin","tagname":"property","owner":"sol.common.mixins.ObjectSort","id":"property-mixin","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"generateSort","tagname":"method","owner":"sol.common.mixins.ObjectSort","id":"method-generateSort","meta":{"private":true}},{"name":"hasSortCriteria","tagname":"method","owner":"sol.common.mixins.ObjectSort","id":"method-hasSortCriteria","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"sortArray","tagname":"method","owner":"sol.common.mixins.ObjectSort","id":"method-sortArray","meta":{}}],"code_type":"ext_define","id":"class-sol.common.mixins.ObjectSort","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":["sol.common.ix.functions.ForEach"],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.mixins.ObjectSort</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.ObjectSortUtils' rel='sol.common.ObjectSortUtils' class='docClass'>sol.common.ObjectSortUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectUtils' rel='sol.common.ObjectUtils' class='docClass'>sol.common.ObjectUtils</a></div><h4>Mixed into</h4><div class='dependency'><a href='#!/api/sol.common.ix.functions.ForEach' rel='sol.common.ix.functions.ForEach' class='docClass'>sol.common.ix.functions.ForEach</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.ObjectSortUtils.html#sol-common-mixins-ObjectSort' target='_blank'>lib_sol.common.ObjectSortUtils.js</a></div></pre><div class='doc-contents'>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div><div id='property-mixin' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.mixins.ObjectSort'>sol.common.mixins.ObjectSort</span><br/><a href='source/lib_sol.common.ObjectSortUtils.html#sol-common-mixins-ObjectSort-property-mixin' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.mixins.ObjectSort-property-mixin' class='name expandable'>mixin</a> : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>true</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-generateSort' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.mixins.ObjectSort'>sol.common.mixins.ObjectSort</span><br/><a href='source/lib_sol.common.ObjectSortUtils.html#sol-common-mixins-ObjectSort-method-generateSort' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.mixins.ObjectSort-method-generateSort' class='name expandable'>generateSort</a>( <span class='pre'>sorts</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sorts</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-hasSortCriteria' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.mixins.ObjectSort'>sol.common.mixins.ObjectSort</span><br/><a href='source/lib_sol.common.ObjectSortUtils.html#sol-common-mixins-ObjectSort-method-hasSortCriteria' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.mixins.ObjectSort-method-hasSortCriteria' class='name expandable'>hasSortCriteria</a>( <span class='pre'>sortCriterias</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sortCriterias</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-sortArray' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.mixins.ObjectSort'>sol.common.mixins.ObjectSort</span><br/><a href='source/lib_sol.common.ObjectSortUtils.html#sol-common-mixins-ObjectSort-method-sortArray' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.mixins.ObjectSort-method-sortArray' class='name expandable'>sortArray</a>( <span class='pre'>arr, sortCriterias, options</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Sort an array by specify sortCriteria. ...</div><div class='long'><p>Sort an array by specify sortCriteria.</p>\n\n<p>Imagine you have the following array:</p>\n\n<pre><code>[ { data: { propA: \"A\", propB: \"B\"} }, {data: { propA: \"A\", propB: \"B\"} }]\n</code></pre>\n\n<p>If you want to sort by propA you can use the following sortCriteria structure.\n { prop: \"data.propA\" }</p>\n\n<p>Now the array will be sort by the object prop <code>propA</code> with ObjectSortUtils.default sort function.</p>\n\n<p>The sortCriteria will be used ObjectUtils.getProp function to determine the object property,\nso the object could be sort by deeper structures as well as flat structures</p>\n\n<p>If you want simple sort an array by a prop you can easily pass the object keypath\ninstead of a sortCritiera object</p>\n\n<p>   sortCriterias: [\"data.propA\"]</p>\n\n<p>A sortCriteria has furthermore options. To use another sorting strategy you can pass\nanother function from ObjectSortUtils. Currently supported functions are default, date, number</p>\n\n<p> sortCriterias: [{ prop: \"data.propDate\", type: \"date\" }]</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>arr</span> : Array&lt;Object&gt;<div class='sub-desc'><p>The array to sort</p>\n</div></li><li><span class='pre'>sortCriterias</span> : Array&lt;Object&gt;<div class='sub-desc'><p>determine the props to sort</p>\n</div></li><li><span class='pre'>options</span> : *<div class='sub-desc'><p>object</p>\n<ul><li><span class='pre'>clone</span> : Boolean (optional)<div class='sub-desc'><p>If you want to sort the original object set this option to false. Default is true</p>\n<p>Defaults to: <code>true</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>sorted array</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{}});